IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CONFIRMACAO_CREDITO_ICMS_ST_PIS_COFINS]') 
					AND type in (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [DBO].[P_CONFIRMACAO_CREDITO_ICMS_ST_PIS_COFINS]
	END
GO

CREATE PROCEDURE [dbo].[P_CONFIRMACAO_CREDITO_ICMS_ST_PIS_COFINS]
    @PROT_ICMS_ST INT
AS
BEGIN

    DECLARE @CD_NF INT;
	DECLARE @CD_FILIAL INT
	DECLARE @CD_EMP INT

    -- Atualizar campo STATUS = 1 (Confirmado)
    UPDATE EST_NF_ENT_ENTRADA_ICMS_ST_MOV SET STATUS = 1 WHERE PROT_ICMS_ST = @PROT_ICMS_ST AND STATUS = 0;


	SELECT @CD_NF = CD_NF_ENT_CRED, 
			@CD_FILIAL = CD_FILIAL,
			@CD_EMP = CD_EMP
	FROM EST_NF_ENT_ENTRADA_ICMS_ST_MOV 
	WHERE PROT_ICMS_ST = @PROT_ICMS_ST;

    -- Verificar se o saldo foi totalmente utilizado
	
	IF EXISTS (
					SELECT 1
					FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS C
					OUTER APPLY (SELECT SUM(QT_IT) QT
								 FROM EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV
								 WHERE CD_NF_ENT_CRED = @CD_NF
								 AND CD_FILIAL = @CD_FILIAL
								 AND CD_EMP = @CD_EMP
								  AND MOV.[STATUS] = 1 /*Confirmada*/) QT_BAIXA
					WHERE CD_NF = @CD_NF
					AND CD_FILIAL = @CD_FILIAL
					AND CD_EMP = @CD_EMP
					HAVING (SUM(C.QT_IT) - SUM(QT_BAIXA.QT)) <= 0
				)
	BEGIN
		UPDATE EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS 
			SET SALDO_ZERADO = 1
		WHERE CD_NF = @CD_NF 
			AND CD_FILIAL = @CD_FILIAL 
			AND CD_EMP = @CD_EMP;
	END

END
GO


